#import	 <Foundation/Foundation.h>	// voor NSLog, @"", NS*

/*
	Oplossing vraag 4a, Bijeenkomst 1
	cc -o vandaag datuma.m -framework Foundation
*/

int main(int argc, char *argv[])
{
	NSAutoreleasePool *pool = [[NSAutoreleasePool alloc] init];

	//	creeer een NSCalenderDate object met de datum van vandaag
	NSCalendarDate *vandaag = [NSCalendarDate calendarDate];
	
	//	ALTERNATIEF 1: stapsgewijs Objective-C
	//	de huidige dag
	int dagIndex   = [vandaag dayOfWeek];
	
	//	gebruik NSArray uit Foundation
	NSArray *dagen = [NSArray arrayWithObjects:
		@"zondag",
		@"maandag",
		@"dinsdag",
		@"woensdag",
		@"donderdag",
		@"vrijdag",
		@"zaterdag",
		nil];
	
	//  afdrukken
	NSString *fmt = @"Het is vandaag %@.";
	NSLog(fmt, [dagen objectAtIndex:dagIndex]);

	//	ALTERNATIEF 2: hetzelfde in C stijl
	char *dag[] = {
		"zondag",
		"maandag",
		"dinsdag",
		"woensdag",
		"donderdag",
		"vrijdag",
		"zaterdag"
	};
	printf("Het is vandaag %s.\n", dag[dagIndex]);

	//	ALTERNATIEF 3: doorgewinterd Cocoa
	//	NSUserDefaults bevat de gelocaliseerde maand en dagnamen
	NSDictionary *loc = [[NSUserDefaults standardUserDefaults] dictionaryRepresentation];
	
	//	descriptionWithCalendarFormat:locale produceert een gelocaliseerde NSString
	NSLog(@"%@", [vandaag descriptionWithCalendarFormat:@"Het is vandaag %A." locale:loc]);

	// netjes afsluiten...
	[pool release];
	return 0;
}