#import "SprekerController.h"

@implementation SprekerController

- (id)init
{
	self = [super init];
	if ( self ) {
		synthesizer = [[NSSpeechSynthesizer alloc] init];
		[synthesizer setDelegate:self];
	}
	return self;
}

- (void)dealloc
{
	[synthesizer release];
	[super dealloc];
}

//	de volgende regels zorgen voor een scheidingsstreepje en een kopje
//	in the Xcode method popup (bovenaan dit scherm)

#pragma mark -
#pragma mark (Bediening)

//	start de synthesizer, en zet de spreek knop in de 'zwijg' stand
- (IBAction)spreek:(id)sender
{
	[synthesizer startSpeakingString:[tekstField stringValue]];
	[sender setTitle:@"Zwijg"];
	[sender setAction:@selector(zwijg:)];
}

//	start de synthesizer, en zet de spreek knop in de 'spreek' stand
- (IBAction)zwijg:(id)sender
{
	[synthesizer stopSpeaking];
	[sender setTitle:@"Spreek"];
	[sender setAction:@selector(spreek:)];
}

#pragma mark -
#pragma mark (NSSpeechSynthesizer Delegate)

- (void)speechSynthesizer:(NSSpeechSynthesizer *)sender
		didFinishSpeaking:(BOOL)finishedSpeaking
{
	//	als de synthesizer klaar is zetten we de spreek knop weer in 'spreek' stand
	//	om code niet onnodig te dupliceren roepen we hier gewoon de zwijg: methode aan.
	[self zwijg:spreekButton];
}

- (void)speechSynthesizer:(NSSpeechSynthesizer *)sender
			willSpeakWord:(NSRange)characterRange
				 ofString:(NSString *)string
{
	//	DEBUG: print argumenten
	//	vermoeden: OS X 10.4.7 stuurt nil voor string argument
	NSLog(@"sender:%@, range:%@, string:%@", sender, NSStringFromRange(characterRange), string);

	//	construeer het 'woord' dat de synthesizer gaat uitspreken
	//	NB: woorden worden niet noodzakelijkerwijs door spaties gescheiden,
	//		probeer bijvoorbeeld eens: 'sdlfk' en 'binnenBand' te laten spreken
	NSString *woord = [string substringWithRange:characterRange];
	if ( [woord isEqualToString:@"STOP"] ) {	//	hoofdlettergevoelig
		[self zwijg:spreekButton];
	}
}

#pragma mark -
#pragma mark (NSApplication Delegate)

//	een object kan delegate zijn van meerdere andere objecten. SprekerController is
//	in dit geval de delegate voor zowel synthezizer als voor NSApp. Maak deze relatie
//	in Interface Builder (NSApp is de 'File's Owner' van de nib file)
- (BOOL)applicationShouldTerminateAfterLastWindowClosed:(NSApplication *)sender
{
	return YES;
}

@end