//
//  DiscotheekController.m
//  Discotheek
//
//  Created by Gast on 25-11-06.
//  Copyright 2006 Cocoa Cursus. All rights reserved.
//

#import "DiscotheekController.h"
#import "ITunesLibrary.h"


@implementation DiscotheekController

//	We ontvangen deze 'notification' automatisch als we de delegate van NSApp zijn.
- (void)applicationDidFinishLaunching:(NSNotification *)notification
{
	//	We zijn alleen geïnteresseerd in playlists die niet leeg zijn (tracks array
	//	bevat minstens 1 track). NSArrayControllers kunnen gefilterd worden m.b.v
	//	een NSPredicate. NSPredicate wordt ook gebruikt voor b.v. CoreData.
	//	@count is een zgn. 'array operator', onderdeel van 'Key Value Coding'.
	//	Zie ook de predicate binding (in IB) van het zoekveld.
	NSPredicate *nonEmptyLists = [NSPredicate predicateWithFormat:@"tracks.@count != 0"];
	[listsController setFilterPredicate:nonEmptyLists];
	
	//	lees de iTunes bibliotheek in
	[library open];
}

//	Verlaat programma als het hoofdvenster wordt gesloten
- (BOOL)windowShouldClose:(id)sender
{
	[NSApp terminate:nil];
	return YES;
}

- (IBAction)focusSearchField:(id)sender
{
	[[searchField window] makeFirstResponder:searchField];
}

@end