//
//  ITunesLibrary.m
//  Discotheek
//
//  Created by patrick machielse on 4-10-06.
//  Copyright 2006 Hieper Software. All rights reserved.
//

#import "ITunesLibrary.h"


@implementation ITunesLibrary

- (void)dealloc
{
	[self setLibrary:nil];
	[self setPlaylists:nil];
	[super dealloc];
}

- (BOOL)open
{
	//	Lees de iTunes xml
	NSString *iTunesXML = [@"~/Music/iTunes/iTunes Music Library.xml" stringByExpandingTildeInPath];
	NSDictionary *iTunesLibrary = [NSDictionary dictionaryWithContentsOfFile:iTunesXML];
	if ( !iTunesLibrary ) {
		NSLog(@"could not read iTunes XML");
		return NO;
	}
	[self setLibrary:iTunesLibrary];
	
	//	Maak de playlists. Een playlist is een dictionay met 2 keys: 'name' (NSString)
	//	en 'tracks' (NSArray van NSDictionaries).
	NSDictionary *allTracks = [self allTracks];
	NSMutableArray *newPlaylists = [NSMutableArray array];
	NSEnumerator *listEnum = [[iTunesLibrary valueForKey:@"Playlists"] objectEnumerator];
	NSDictionary *list;
	while ( list = [listEnum nextObject] ) {
		NSMutableArray *listTracks = [NSMutableArray array];
		NSEnumerator *itemEnum = [[list objectForKey:@"Playlist Items"] objectEnumerator];
		NSDictionary *item;	//	dictionary met een Track ID
		while ( item = [itemEnum nextObject] ) {
			//	De playlist dictionaries in de iTunes xml bevatten alleen de
			//	Track IDs. Voor iedere playlist zoeken we m.b.v. deze IDs de 
			//	volledige track dictionaries in allTracks.
			NSString *trackID = [[item objectForKey:@"Track ID"] stringValue];
			
			//	Het blijkt dat sommige tracks nog niet 'bestaan'; wel een Track ID
			//	in een playlist, maar nog niet in 'allTracks' (b.v. niet opgehaalde
			//	podcasts). We willen geen 'nil' tracks aan 'listTracks' toevoegen!
			id   track = [allTracks objectForKey:trackID];
			if ( track ) {
				[listTracks addObject:track];
			}
		}
		
		//	voeg een nieuwe playlist toe met de verzamelde tracks
		[newPlaylists addObject:[NSDictionary dictionaryWithObjectsAndKeys:
			listTracks,					@"tracks",
			[list valueForKey:@"Name"],	@"name", nil]];
	}
	[self setPlaylists:newPlaylists];
	return YES;
}

#pragma mark -
#pragma mark ( Accessors )

- (NSDictionary *)library
{
    return [[library retain] autorelease]; 
}

- (void)setLibrary:(NSDictionary *)newLibrary
{
    if (library != newLibrary) {
        [library release];
        library = [newLibrary retain];
    }
}

- (NSArray *)playlists
{
    return [[playlists retain] autorelease]; 
}

- (void)setPlaylists:(NSArray *)newPlaylists
{
    if (playlists != newPlaylists) {
        [playlists release];
        playlists = [newPlaylists retain];
    }
}

- (NSDictionary *)allTracks
{
    return [[self library] objectForKey:@"Tracks"]; 
}

@end