//
//  Player.h
//  Discotheek
//
//  Created by Gast on 25-11-06.
//  Copyright 2006 Cocoa Cursus. All rights reserved.
//

#import <QTKit/QTKit.h>


//	We gebruiken een ListTrack struct om de locatie en track van het huidige
//	nummer op te slaan. Hiermee kunnen we het nummer terugvinden.
typedef struct {
	NSDictionary *list;
	NSDictionary *track;
} ListTrack;


@interface Player : NSObject
{
	QTMovie							*movie;			//	speelt muziek af
	ListTrack						listTrack;		//	locatie van track
	
	IBOutlet	NSTableView			*tracksTable;
	IBOutlet	NSArrayController	*listsController;
	IBOutlet	NSArrayController	*tracksController;
}
//	playback
- (IBAction)play:(id)sender;
- (IBAction)stop:(id)sender;
- (IBAction)reveal:(id)sender;

//	accessors
- (QTMovie *)movie;
- (void)setMovie:(QTMovie *)value;
- (ListTrack)listTrack;
- (void)setListTrack:(ListTrack)value;
- (BOOL)canReveal;

@end
