//
//  Player.m
//  Discotheek
//
//  Created by Gast on 25-11-06.
//  Copyright 2006 Cocoa Cursus. All rights reserved.
//

#import "Player.h"


@implementation Player

- (id)init
{
	self = [super init];
	if ( self ) {
		[self setListTrack:(ListTrack){ nil, nil }];
		[[NSNotificationCenter defaultCenter] addObserver:self
												 selector:@selector(movieDidEnd:)
													 name:QTMovieDidEndNotification
												   object:nil];
	}
	return self;
}

- (void)awakeFromNib
{
	//	speel track af door dubbelklikken
	[tracksTable setTarget:self];
	[tracksTable setDoubleAction:@selector(play:)];
}

- (void)dealloc
{
	[[NSNotificationCenter defaultCenter] removeObserver:self];
	[self setMovie:nil];
	[super dealloc];
}

#pragma mark -
#pragma mark ( Playback )

- (IBAction)play:(id)sender
{
	//	er moet een track geselecteerd zijn
	NSArray *tracks = [tracksController selectedObjects];
	if ( [tracks count] == 0 ) {
		return;
	}
	
	//	locatie van het bestand
	NSDictionary *track = [tracks objectAtIndex:0];
	NSURL *url = [NSURL URLWithString:[track objectForKey:@"Location"]];
	
	//	probeer als 'movie' af te spelen
	NSError *error;
	QTMovie *newMovie = [QTMovie movieWithURL:url error:&error];
	if ( !newMovie) {
		[NSApp presentError:error];
		return;
	}
	[newMovie play];
	
	//	bewaar movie en afspeellocatie
	[self setMovie:newMovie];
	id list = [[listsController selectedObjects] lastObject];
	[self setListTrack:(ListTrack) { list, track }];
}

- (IBAction)stop:(id)sender
{
	[[self movie] stop];
	[self setMovie:nil];
	[self setListTrack:(ListTrack) { nil, nil }];
}

- (IBAction)reveal:(id)sender
{
	if ( ![self canReveal] ) {
		return;
	}
	//	selecteer de spelende track
	[listsController setSelectedObjects:[NSArray arrayWithObject:listTrack.list]];
	[tracksController setSelectedObjects:[NSArray arrayWithObject:listTrack.track]];
	[[tracksTable window] makeFirstResponder:tracksTable];	//	'focus' de table view
}

- (void)movieDidEnd:(NSNotification *)not
{
	[self stop:nil];
}

#pragma mark -
#pragma mark ( accessors )

- (QTMovie *)movie
{
    return [[movie retain] autorelease];
}

- (void)setMovie:(QTMovie *)value
{
    if (movie != value) {
        [movie release];
        movie = [value retain];
    }
}

- (ListTrack)listTrack
{
    return listTrack;
}

- (void)setListTrack:(ListTrack)value
{
	listTrack = value;
}

- (BOOL)canReveal
{
	return listTrack.list && listTrack.track;	//	YES als geen van beiden nil
}

@end